//basic PIC32 UART implementation
//software rx and tx buffers set by UART_BUFFER_SIZE
//similar model to Arduino

#ifndef _UART_H    /* Guard against multiple inclusion */
#define _UART_H
#include <xc.h>
#include <sys/attribs.h>

int uart_init(unsigned long baud);  //assume 8N1 for now, default micromite pins 11 and 12- requires FSOSCEN = OFF, returns BRG
int uart_send(int b);                //use arduino form
int uart_print(char *c);             //send char array
int uart_printi(int n);              //print an int
int uart_printl(long n);             //print a long
int uart_receive();                  //returns -1 on no data
int uart_available();                //queued in rx
int uart_tx_available();             //queued in tx
void inttochar(long n, char *c);     //for printing numbers

#define UART_BUFFER_SIZE 256

volatile char uart_tx_buffer[UART_BUFFER_SIZE],uart_rx_buffer[UART_BUFFER_SIZE];
volatile unsigned int uart_tx_buffer_head,uart_tx_buffer_tail,uart_rx_buffer_head,uart_rx_buffer_tail;

#endif /* _UART_H */
